<?php

namespace Solokod\SoloKargo;

class Config
{
    public static function getVersion(): string
    {
        $file = plugin_dir_path(dirname(__FILE__, 1)) . 'solokargo.php';
        $pluginData = get_plugin_data($file);
        return $pluginData['Version'];
    }

    public static function getAPIAddress(): string
    {
            /*
        $result = wp_remote_get(SOLOKARGO_URL .'/composer.json');
        $config = json_decode(wp_remote_retrieve_body($result), true);
        $urls = $config['extra']['api-urls'] ?? [];

        error_log("Plugine Mode: " . print_r(wp_is_development_mode("plugin"), true));

        return wp_is_development_mode("plugin") 
            ? "{$urls['development']}/api/v1/"
            : "{$urls['production']}/api/v1/";
            */

            $pluginDir = plugin_dir_path(__FILE__);
            $composerPath = SOLOKARGO_DIR . 'composer.json';
        
            if (file_exists($composerPath)) {
                return 'http://localhost:3030/api/v1/';
            } else {
                return 'https://kapi.solokod.com/api/v1/';
            }
    }

    public static function getFirmName(string $firmCode): string
    {
        return match ($firmCode) {
            'aras' => 'Aras',
            'surat' => 'Sürat',
            'yurtici' => 'Yurtiçi',
            'mng' => 'MNG',
            'test' => 'Test',
            default => 'Unknown',
        };
    }
}