<?php

namespace Solokod\SoloKargo;

class KargoApi
{
    public function createCargo(array $params): array
    {
        $response = $this->apiRequest('create', $params);
        return $response;
    }

    public function queryCargo(array $params): array
    {
        $response = $this->apiRequest('query', $params);
        return $response;
    }

    public function cancelCargo(array $params): array
    {
        // Kargo bilgileri hazırla ve apiye gonder
        $response = $this->apiRequest('cancel', $params);

        $result = array(
            'status' => $response['status'],
            'message' => $response['message']
        );

        return $result;
    }

    public function getLicence(string $site, string $licenceKey): array
    {
        $params = array(
            'site' => $site,
            'licenceKey' => $licenceKey,
        );

        $response = $this->apiRequest('licence', $params);

        return $response;
    }

    private function apiRequest(string $action, array $data): array
    {
        $options = array(
            'headers' => array('Authorization' => 'Basic ' . base64_encode($data["licenceKey"])),
            'body' => wp_json_encode($data),
            'method' => 'POST',
            'data_format' => 'body',
            'timeout' => 45,
            'redirection' => 5,
            'httpversion' => '1.0',
            'blocking' => true
        );

        $response = wp_remote_post(Config::getAPIAddress() . $action, $options);

        // Kargo API isteminde bir hata varsa islemi durdur.
        if (is_wp_error($response)) {
            return array(
                'status' => false,
                'message' => $response->get_error_message()
            );
        }

        // Donen firma api bilgilerini ver
        return json_decode(wp_remote_retrieve_body($response), true);
    }
}
