<?php

namespace Solokod\SoloKargo\Modules;

class Assets
{
    public function __construct()
    {
        add_action("admin_enqueue_scripts", [$this, "loadAdminStyles"]);
    }

    public function loadAdminStyles()
    {
        $this->loadAssets('dashboard');
        $this->loadAssets('metabox');
        $this->loadAssets('yurtici');
        $this->loadAssets('surat');
        $this->loadAssets('aras');
        $this->loadAssets('mng');
        $this->loadAssets('test');
        $this->loadAssets('bulkActions');

        wp_enqueue_style('wp-components');

        wp_enqueue_script("solokargo-nonce", SOLOKARGO_URL . "build/metabox.js", array(), '1.0', true);
    
        $nonce = wp_create_nonce('solokargo_nonce');
        wp_localize_script("solokargo-nonce", "solokargoNonce", array(
            "nonce" => $nonce,
            "ajaxUrl" => admin_url('admin-ajax.php'))
        );
    }

    private function loadAssets(string $assetKey)
    {
        $style = SOLOKARGO_DIR . 'build/' . $assetKey . '.css';
        if (file_exists($style)) {
            wp_enqueue_style('solokargo-' . $assetKey, SOLOKARGO_URL . 'build/' . $assetKey . '.css', array(), time());
        }

        $asset = SOLOKARGO_DIR . 'build/' . $assetKey . '.asset.php';
        if (file_exists($asset)) {
            $assets = require_once $asset;
            wp_enqueue_script('solokargo-' . $assetKey, SOLOKARGO_URL . 'build/' . $assetKey . '.js', $assets['dependencies'], $assets['version'], true);
        }
    }
}
