<?php

namespace Solokod\SoloKargo\Modules;

use WC_Email;
use WC_Order;

class KargoMail extends WC_Email
{
    public function __construct()
    {
        $this->id = 'soloKargoTakipBildirim';
        $this->title = __('SoloKargo Takip Bildirim', 'solokargo');
        $this->customer_email = true;
        $this->email_type = 'multipart';
        $this->description = __('SoloKargo gönderi takip durumlarını müşteriye ileten eposta şablonudur.', 'solokargo');

        $this->heading = __('Siparişiniz kargoya verildi', 'suratkargo');
        $this->subject = __('Siparişiniz kargoya verildi!', 'suratkargo');
        $this->customer_email = true;

        $this->template_base  = WP_PLUGIN_DIR . '/solokargo/includes/templates/';
        $this->template_html  = 'emails/solo-kargo-takip.php';
        $this->template_plain = 'emails/solo-kargo-takip.php';

        parent::__construct();
    }

    public function trigger(int $orderID)
    {
        error_log('takip posta gonderimi tetiklendi... OrderID: ' . $orderID);

        // bail if no order ID is present
        if (!$orderID) {
            return;
        }

        // setup order object
        $order = wc_get_order($orderID);

        if (!$order || !$order instanceof WC_Order) {
            return; // Geçersiz sipariş nesnesi ise çık
        }

        $this->object = $order; // E-posta nesnesine siparişi atayın
        $this->recipient = $this->object->get_billing_email(); // Sipariş nesnesinden e-posta adresini alın

        // Aktif degilse veya alici yoksa iptal et
        if (!$this->is_enabled() || !$this->get_recipient()) {
            return;
        }

        $kargoLink = 'https://suratkargo.com.tr/kargotakip?kargotakipno=' . $order->get_meta('solokargo_cargo_key');

        // replace variables in the subject/headings
        $this->placeholders['{order_id}'] = $order->get_id();
        $this->placeholders['{name}'] = $order->get_billing_first_name() . ' ' . $order->get_billing_last_name();
        $this->placeholders['{kargoDurum}'] = $order->get_meta('solokargo_cargo_status');
        $this->placeholders['{kargoTakipURL}'] = '<a href="' . $kargoLink . '" target="_blank">' . $kargoLink . '</a>';

        // woohoo, send the email!
        $this->send($this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments());

        // add order note about the same
        $this->object->add_order_note(sprintf(__('%s epostası müşteriye gönderildi.', 'solokargo'), $this->title));
    }

    public function get_content_html()
    {
        return wc_get_template_html($this->template_html, array(
            'order' => $this->object,
            'email_heading' => $this->get_heading(),
            'additional_content' => $this->get_additional_content(),
            'sent_to_admin' => false,
            'plain_text' => false,
            'email' => $this
        ), '', $this->template_base);
    }

    public function get_content_plain()
    {
        return wc_get_template_html($this->template_plain, array(
            'order' => $this->object,
            'email_heading' => $this->get_heading(),
            'additional_content' => $this->get_additional_content(),
            'sent_to_admin' => false,
            'plain_text' => true,
            'email' => $this
        ), '', $this->template_base);
    }

    public function get_default_additional_content()
    {
        return <<<EOD
            Sayın {name},
            Sitemizden alışveriş yaptığınız için teşekkür ederiz. {order_id} numaralı sipariş kargoya verildi.
            Siparişinizin takibi için gerekli kargo bilgileri aşağıdaki gibidir.

            Kargo Durumu: {kargoDurum}
            Takip Linki : {kargoTakipURL}
        EOD;
    }
}
