<?php

namespace Solokod\SoloKargo\Modules;

use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;

class Metabox
{
    public function __construct()
    {
        add_action('add_meta_boxes', [$this, 'registerMetaBox']);
    }

    public function registerMetaBox()
    {
        $screenLegacyOrHpos = class_exists( '\Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController' ) && wc_get_container()->get( CustomOrdersTableController::class )->custom_orders_table_usage_is_enabled()
        ? wc_get_page_screen_id('shop-order')
        : 'shop_order';

        $id = 'solokargoMetabox';
        $title = 'SoloKargo Entegrasyon';
        $callable = [$this, 'registerMetaBoxView'];
        $screen = $screenLegacyOrHpos;  // 'woocommerce_page_wc-orders'; 'shop_order';
        $context = 'side';
        $priority = 'default';
        $callback_args = null;

        add_meta_box($id, $title, $callable, $screen, $context, $priority, $callback_args);
    }

    public function registerMetaBoxView($post_or_order_object)
    {
        $order = ($post_or_order_object instanceof \WP_Post)
            ? wc_get_order($post_or_order_object->ID)
            : $post_or_order_object;

        $orderID = $order->get_id();
        $selectedFirm = $order->get_meta('solokargo_selected_firm');
        $defaultFirm = get_option('solokargo_default_firm');

        echo '<div id="solokargobox" data-orderid="' . esc_attr($orderID) . '" data-defaultfirm="' . esc_attr($defaultFirm) . '" data-selectedfirm="' . esc_attr($selectedFirm) . '"><h2>Loading...</h2></div>';
    }
}
