<?php

namespace Solokod\SoloKargo\Payment;

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class GatewayBlocksSupport extends AbstractPaymentMethodType
{
    private $gateway;
    protected $name = 'kapida_odeme_kart'; // payment gateway id

    public function initialize()
    {
        // get payment gateway settings
        $this->settings = get_option("woocommerce_{$this->name}_settings", array());
        $this->gateway = new KapidaOdemeKart();
    }

    public function is_active()
    {
        return $this->gateway->is_available();
    }

    public function get_payment_method_script_handles()
    {
        wp_register_script(
            'wc-solokargo-blocks-integration',
            plugin_dir_url(__DIR__) . '../build/kapidaOdeme.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
            ],
            time(), // or time() or filemtime( ... ) to skip caching
            true
        );

        return ['wc-solokargo-blocks-integration'];
    }

    public function get_payment_method_data()
    {
        return [
            'title' => 'Kapıda Ödeme (Kredi Kartı)',
            'description' => 'Teslimat anında kapıda kredi kartı ile ödeme.'
        ];
    }
}
