<?php

namespace Solokod\SoloKargo\Payment;

use WC_Payment_Gateway;

class KapidaOdemeKart extends WC_Payment_Gateway
{
    public function __construct()
    {
        // Setup general properties.
        $this->setup_properties();

        // gateways can support subcriptions, refunds ,saved payment methods,
        // but in this tutorial we begin with simple payments
        // $this->supports = array("products");

        // Load the settings.
        $this->init_form_fields();
        $this->init_settings();

        // Get settings.
        $this->title = $this->get_option('title');
        $this->description = $this->get_option('description');
        $this->enabled = $this->get_option("enabled");

        // This action hook saves the settings
        add_action('woocommerce_update_options_payment_gateways_{$this->id}', [$this, 'process_admin_options']);
    }

    protected function setup_properties()
    {
        $this->id = 'kapida_odeme_kart';
        $this->icon = apply_filters('woocommerce_cod_icon', '');
        $this->method_title = __('Kapıda ödeme (Kredi Kartı)', 'solokargo');
        $this->method_description = __('SoloKargo kapıda ödeme (kredi kartı) seçeneği ödemenin teslimat anında yapılmasını sağlar.', 'solokargo');
        $this->has_fields = false;
    }

    public function init_form_fields()
    {
        //$this->init_settings();
        $this->form_fields = array(
            "enabled" => array(
                "title" => "Etkinleştir/Etkisizleştir",
                "type" => "checkbox",
                "label" => "Kapıda ödemeyi (kredi kartı) etkinleştir",
                "default" => "no",
            ),
            "title" => array(
                "title" => "Başlık",
                "type" => "text",
                "description" => "Ödeme sayfasında kullanıcılara gösterilecek ödeme yöntemi başlığı",
                "default" => "SoloKargo Kapıda Ödeme",
                "desc_tip" => true,
            ),
            "description" => array(
                "title" => "Açıklama",
                "type" => "textarea",
                "description" => "Sürat kargo kapıda ödeme yöntemi.",
                "default" => "Teslimat anında kapıda ödeme",
            ),
        );
    }

    public function process_payment($order_id)
    {
        $order = wc_get_order($order_id);

        // Ödeme başarılıysa
        $order->update_status('processing', __('Ödeme başarılı', 'woocommerce'));

        // Sepeti boşalt
        WC()->cart->empty_cart();

        // Teşekkür sayfasına yönlendir
        return array(
            'result' => 'success',
            'redirect' => $this->get_return_url($order)
        );
    }

    public function validate_fields()
    {
        return true;
    }

    public function payment_fields()
    {
        // display the description with <p> tags etc.
        echo wpautop(wp_kses_post($this->description));
    }

    public function is_available()
    {
        // Ödeme yöntemi genel olarak etkin mi kontrol et
        if ('yes' === $this->enabled) {
            return true;
        }
        return false;
    }
}
