<?php
namespace Solokod\SoloKargo;

use DI\ContainerBuilder;

use Solokod\SoloKargo\KargoApi;
use Solokod\SoloKargo\Modules\Assets;
use Solokod\SoloKargo\Modules\Metabox;
use Solokod\SoloKargo\Modules\Startup;
use Solokod\SoloKargo\Services\BoxService;
use Solokod\SoloKargo\Services\OptionService;

class Plugin
{
    protected static $instance = null;

    protected function __construct()
    {
        $classes = array(
            'KargoApi' => \DI\autowire(KargoApi::class),
            'Assets' => \DI\autowire(Assets::class),
            'Startup' => \DI\autowire(Startup::class),
            'Metabox' => \DI\autowire(Metabox::class),
            'BoxService' => \DI\autowire(BoxService::class),
            'OptionService' => \DI\autowire(OptionService::class)

            //'Helper' => function () { return new Helper(0); },
        );

        $builder = new ContainerBuilder();
        $builder->addDefinitions($classes);
        $container = $builder->build();

        foreach ($classes as $alias => $abstract) {
            $container->get($alias);
        }
    }
    
    public static function getInstance(): Plugin
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }
}
