<?php

namespace Solokod\SoloKargo\Services;

use \Datetime;
use WP_REST_Controller;
use WP_REST_Request;
use WP_REST_Response;
use Solokod\SoloKargo\KargoApi;

class OptionService extends WP_REST_Controller
{
    private KargoApi $kargoApi;

    public function __construct(KargoApi $kargoApi)
    {
        $this->kargoApi = $kargoApi;

        add_action('rest_api_init', [$this, 'registerRoutes']);
    }

    public function registerRoutes()
    {
        $version = '1';
        $namespace = 'solokargo/v' . $version;

        register_rest_route(
            $namespace,
            '/option',
            array(
                [
                    'methods' => 'GET',
                    'callback' => [$this, 'getOption'],
                    'permission_callback' => '__return_true',
                ],
                [
                    'methods' => 'POST',
                    'callback' => [$this, 'setOption'],
                    'permission_callback' => '__return_true',
                ]
            )
        );
        register_rest_route(
            $namespace,
            '/option/licence',
            array(
                [
                    'methods' => 'POST',
                    'callback' => [$this, 'setLicence'],
                    'permission_callback' => '__return_true',
                ]
            )
        );
    }

    public function getOption(WP_REST_Request $request): WP_REST_Response
    {
        $key = $request['key'];
        $option = get_option($key);

        if (!$this->isJson($option)) {
            $option = wp_json_encode([$key => $option]);
        }

        $result = [
            'status' => true,
            'multiple' => $this->isJson($option),
            'data' => json_decode($option),
        ];

        return $this->rezponse($result);
    }

    public function setOption(WP_REST_Request $request): WP_REST_Response
    {
        $key = $request['key'];
        $value = $request->get_body_params();

        $optionResult = update_option($key, $value['data']);

        $msg = $optionResult || empty($optionResult)
            ? 'Bilgiler sisteme başarıyla eklendi.'
            : 'Kayıt esnasında hatalar oluştu. Lütfen kontrol edin';

        $result = [
            'status' => true,
            'message' => $msg
        ];

        return $this->rezponse($result);
    }

    public function setLicence(WP_REST_Request $request): WP_REST_Response
    {
        $key = $request['key'];
        $value = $request->get_body_params();

        $site = $value['site'];
        $licenceKey = $value['licenceKey'];

        $response = $this->kargoApi->getLicence($site, $licenceKey);

        if ($response['status']) {  // Licence is validate
            $licence = $response['data'];
            $option = [
                'site' => $value['site'],
                'licenceKey' => $value['licenceKey'],
                'customerID' => $licence['customerID'],
                'subscribeType' => $licence['subscribeType'],
                'subscribeFirm' => $licence['subscribeFirm'],
                'beginDate' => $licence['beginDate'],
                'endDate' => $licence['endDate']
            ];

            $firms = explode(',', $licence['subscribeFirm']);
            $optionResult = update_option('solokargo_default_firm', $firms[0]);
            $optionResult = update_option('solokargo_licence_key', $licenceKey);
            $optionResult = update_option('solokargo_customer_id', $licence['customerID']);
            $optionResult = update_option($key, wp_json_encode($option));
            $msg = $optionResult || empty($optionResult)
                ? 'Bilgiler sisteme başarıyla eklendi. Lisans bilgilerini aktif hale getirmek için lütfen sayfayı yeniden yükleyin.'
                : 'Kayıt esnasında hatalar oluştu. Lütfen kontrol edin';

        } else {
            $msg = $response['message'];
            wc_get_logger()->info('Lisans bilgilerinde bir hata var.', $response);
            delete_option('solokargo_default_firm');
            delete_option('solokargo_licence_key');
            delete_option($key);
        }

        $result = [
            'status' => true,
            'message' => $msg
        ];

        return $this->rezponse($result);
    }

    private function rezponse(array $data): WP_REST_Response
    {
        $response = new WP_REST_Response($data, 200);
        $response->header("Content-type", "application/json; charset=utf-8");

        return $response;
    }

    private function isJson(string $str)
    {
        json_decode($str);
        return json_last_error() === JSON_ERROR_NONE;
    }
}
