<?php

namespace Solokod\SoloKargo;

use Parsedown;

class Update
{
    private $slug;
    private $pluginData;
    private $pluginFile;
    private $codebergAPIResult;

    function __construct($pluginFile)
    {
        $this->pluginFile = $pluginFile;

        /*
        $res = delete_transient('update_plugins');
        $info =  $res ? "Silindi": "Kaldı";
        error_log("Transient delete status -> $info");
        */

        add_action('admin_init', [$this, 'setPluginData']);
        add_filter("pre_set_site_transient_update_plugins", [$this, "setTransitent"]);
        add_filter("plugins_api", [$this, "setPluginInfo"], 10, 3);
        add_filter("upgrader_post_install", [$this, "postInstall"], 10, 3);
    }

    public function setPluginData(): void
    {
        if (!function_exists('get_plugin_data')) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $this->pluginData = get_plugin_data($this->pluginFile);
        $this->slug = plugin_basename($this->pluginFile);
    }

    public function setTransitent($transient): mixed
    {
        if (empty($transient->checked)) {
            return $transient;
        }

        $releaseInfo = $this->getRepoReleaseInfo();
        if ($releaseInfo === false) {
            return $transient;
        }

        $current_version = isset($transient->checked[$this->slug]) ? $transient->checked[$this->slug] : '0';
        $latest_version = isset($releaseInfo['tag_name']) ? $releaseInfo['tag_name'] : '0';

        if (version_compare($current_version, $latest_version, '<')) {
            $package = $releaseInfo['zipball_url'];

            $obj = new \stdClass();
            $obj->slug = $this->slug;
            $obj->new_version = $releaseInfo['tag_name'];
            $obj->url = $this->pluginData["PluginURI"];
            $obj->package = $package;

            $transient->response[$this->slug] = $obj;
        }

        return $transient;
    }

    public function setPluginInfo($false, $action, $response)
    {
        if (empty($response->slug) || $response->slug != $this->slug) {
            return $false;
        }

        $header = get_file_data($this->pluginFile, array(
            'Tested' => 'Tested up to',
        ));

        $releaseInfo = $this->getRepoReleaseInfo();

        $response->last_updated = $releaseInfo['published_at'];
        $response->slug = $this->slug;
        $response->name = $this->pluginData["Name"];
        $response->plugin_name = $this->pluginData["Name"];
        $response->version = $releaseInfo['tag_name'];
        $response->author = $this->pluginData["Author"];
        $response->homepage = $this->pluginData["PluginURI"];
        $response->requires = $this->pluginData['RequiresWP'];
        $response->tested = $header['Tested'];
        $response->requires_php = $this->pluginData['RequiresPHP'];

        $response->sections = array(
            'description' => $this->getPluginDescription(),
            'installation' => 'Güncelleme düğmesine basın ve hepsi bu kadar',
            'changelog' => class_exists("Parsedown")
                ? Parsedown::instance()->parse($releaseInfo['body'])
                : $releaseInfo['body']
        );

        $response->banners = array(
            'low' => 'https://plugin.solokod.com/suratkargo/banner-772x250.png',
            'high' => 'https://plugin.solokod.com/suratkargo/banner-1544x500.png'
        );

        return $response;
    }

    public function postInstall($true, $hook_extra, $result)
    {
        $basePath = substr($this->pluginFile, 0, strpos($this->pluginFile, "/"));
        $pluginFolder = WP_PLUGIN_DIR . '/' . $basePath;

        global $wp_filesystem;
        $wp_filesystem->move($result['destination'], $pluginFolder);
        $result['destination'] = $pluginFolder;

        if ($this->activatePlugin($basePath . "/" . $this->slug)) {
            //plugin activation failed
        }
        return $result;
    }

    private function activatePlugin($plugin)
    {
        $activate = activate_plugin($plugin);
        return is_wp_error($activate);
    }

    private function getRepoReleaseInfo()
    {
        if (!empty($this->codebergAPIResult)) {
            return $this->codebergAPIResult;
        }

        $url = Config::getAPIAddress() . "update";
        $response = wp_remote_get($url);

        if (is_wp_error($response)) {
            error_log("Hata oluştu -> " . print_r($response, true));
            return false;
        }

        $releaseData = json_decode(wp_remote_retrieve_body($response), true);

        if (!is_array($releaseData) || empty($releaseData)) {
            return false;
        }

        // Codeberg API'den dönen veriyi GitHub formatına uyarlama
        $this->codebergAPIResult = array(
            'tag_name' => $releaseData['tag_name'],
            'published_at' => $releaseData['published_at'],
            'zipball_url' => $releaseData['zipball_url'],
            'body' => $releaseData['body'],
        );

        return $this->codebergAPIResult;
    }

    private function getPluginDescription()
    {
        $description = '
            Adds a simple, no-fuss SMTP settings to your WordPress installation that 
            lets you define custom settings, which is especially useful for hosts 
            with no control over the php `mail` functionality.<br><br>

            If logging is enabled, a new segment in the settings panel will show up 
            with a 30-day overview of recent emails, and will automatically prune older logs.
            Please see the FAQ if you want a more permanent solution.<br><br>

            For more information, please see the <a href="https://github.com/soup-bowl/wp-simple-smtp/wiki">project wiki on GitHub</a>.
        ';

        return $description;
    }
}