<?php
if (!defined('ABSPATH')) exit;

use Solokod\SoloKargo\Helper;

if (!isset($orderIDs) || empty($orderIDs)) {
    $msg = '
        Barkod basımı için öncelikle listeden barkodlarını oluşturmak
        istediğiniz siparişleri seçmelisiniz. Henüz hiç seçim yapmadınız.
        Lütfen kontrol ederek tekrar deneyin.';
    wp_die(esc_html($msg));
}

$orderIDList = explode(',', $orderIDs);
$sender = json_decode(get_option('solokargo_sender_info'));

for($i = 0; $i < count($orderIDList); $i++) {
    $helper = new Helper($orderIDList[$i]);

    $barcode = $helper->getCargoBarcode();

    $customerName = $helper->getCustomerName();
    $customerAddress = $helper->getCustomerAddress();
    $customerCity = $helper->getCustomerCity();
    $customerTown = $helper->getCustomerTown();
    $customerPhone = $helper->getCustomerPhone();
    $paymentMethod = $helper->getPaymentMethod();
    $orderTotal = $helper->getOrderTotal();

    if ($sender->barcodeTemplate == 'template1') {
        include 'template-1.php';
    } else if ($sender->barcodeTemplate == 'template2') {
        include 'template-2.php';
    } else if ($sender->barcodeTemplate == 'template3') {
        include 'template-3.php';
    }
}
?>

<script src="<?php echo SOLOKARGO_URL ?>includes/templates/barcodes/JsBarcode.all.min.js"></script>
<script>
    JsBarcode(".barcode").init();
</script>