<?php

/**
 * Plugin Name:         SoloKargo
 * Plugin URI:          https://solokod.com
 * Description:         WooCommerce için geliştirilen ve kargo süreçlerinizi başarılı bir şekilde yöneten eklentidir.
 * Version:             1.3.0
 * Author:              Solokod
 * Author URI:          https://solokod.com/
 * Requires PHP:        8.0
 * Requires at least:   6.5
 * Tested up to:        6.6.2
 * Text Domain:         solokargo
 */

use Solokod\SoloKargo\Plugin;
use Solokod\SoloKargo\Update;

defined("ABSPATH") || exit;

define('SOLOKARGO_URL', plugin_dir_url(__FILE__));
define('SOLOKARGO_DIR', plugin_dir_path(__FILE__));

require_once dirname(__FILE__) . "/vendor/autoload.php";

function solokargo_initialize()
{
    if (!class_exists('WooCommerce')) {
        return;
    }

    $GLOBALS['solokargo'] = Plugin::getInstance();
}
add_action('woocommerce_loaded', 'solokargo_initialize', 10);

if (is_admin()) {
    new Update(__FILE__);
}