import { useMutation, useQuery } from "@tanstack/react-query";

const API_URL = `${window.location.origin}/wp-json/solokargo/v1`;

export function useGetEntryParams() {
    return useQuery({
        queryKey: ['entryParams'],
        queryFn: () => fetch(`${API_URL}/metabox/entry`).then(res => res.json()),
        refetchOnWindowFocus: false,
        gcTime: 1000 * 60 * 60, // 1 hour
    });
}


export function useSetEntryParams() {
    return useMutation({
        mutationFn: async (params) => {
            const options = {
                header: { 'Accept': 'application/json' },
                method: "POST",
                body: params,
            }
            const response = await fetch(`${API_URL}/metabox/entry`, options);
            const data = await response.json();
            return data;
        }
    });
}

export function useDeleteCargoParams() {
    return useMutation({
        mutationFn: async (orderID) => {
            const options = {
                header: { 'Accept': 'application/json' },
                method: "DELETE",
            }
            const response = await fetch(`${API_URL}/metabox/detail?id=${orderID}`, options);
            const data = await response.json();
            return data;
        }
    });
}

// Get cargo info for detail page
export function useGetCargoInfo(orderID, isApiQuery) {
    return useQuery({
        queryKey: ['cargoInfo', orderID, isApiQuery],
        queryFn: async () => {
            const response = await fetch(`${API_URL}/metabox/detail?id=${orderID}&query=${isApiQuery}`);
            const data = await response.json();
            return data;
        },
        refetchOnWindowFocus: false,
        staleTime: 0, // Hemen yenile
        cacheTime: 1000 * 60 * 5, // 5 dakika
    });
}

// Get barcode info for print dialog
export function useGetPrintInfo(orderID) {
    return useQuery({
        queryKey: ['printParams', orderID],
        queryFn: async () => {
            const response = await fetch(`${API_URL}/metabox/print?id=${orderID}`);
            const data = await response.json();
            return data;
        }
        // enabled: false
    });
}