import { useMutation, useQuery } from "@tanstack/react-query";

const API_URL = `${window.location.origin}/wp-json/solokargo/v1`;

export function useGetOption(key) {
    return useQuery({
        queryKey: ['option', key],
        queryFn: async () => {
            const option = await fetch(`${API_URL}/option?key=${key}`);
            const data = await option.json();
            return data.data;
        }
    });
}

export function useSetOption() {
    return useMutation({
        mutationFn: async (params) => {
            const options = {
                header: { 'Accept': 'application/json' },
                method: "POST",
                body: params.value,
            }
            const response = await fetch(`${API_URL}/option?key=${params.key}`, options);
            const data = await response.json();
            return data;
        }
    });
}

export function useSetLicence() {
    return useMutation({
        mutationFn: async (params) => {
            const options = {
                header: { 'Accept': 'application/json' },
                method: "POST",
                body: params.value,
            }
            const response = await fetch(`${API_URL}/option/licence?key=${params.key}`, options);
            const data = await response.json();
            return data;
        }
    });
}