
document.addEventListener('DOMContentLoaded', function () {
    var orderList = [];

    // wc-orders-filter id'sine sahip formu seç
    var filterForm = document.getElementById('wc-orders-filter');

    if (filterForm) {
        // Form submit olayını yakala
        filterForm.addEventListener('submit', function (e) {
            const selectElement = document.getElementById('bulk-action-selector-top');
            const selectedValue = selectElement.value;

            const selectedCheckboxes = document.querySelectorAll('input[name="id[]"]:checked');
            const selectedIds = Array.from(selectedCheckboxes).map(checkbox => checkbox.value);

            if (selectedValue === 'solokargo_bulk-shipment') {
                e.preventDefault();
                openModal(selectedIds);
            }

            if (selectedValue === 'solokargo_bulk-barcode') {
                e.preventDefault();
                createBarcodeIFrame(selectedIds);
            }
        })
    }

    // Modal'ı açmak için fonksiyon
    async function openModal(selectedIds) {
        orderList = await getOrderList(selectedIds);

        let html = '<ul id="solokargoSendOrderList">';
        orderList.forEach(value => {
            if (value.isSend) {
                html += `<li data-id="${value.id}">#${value.id} ${value.customer} -- kargolanmış</li>`;
            } else {
                html += `<li data-id="${value.id}">#${value.id} ${value.customer}</li>`;
            }

        });
        html += '</ul>';

        const defaultFirm = orderList[0].defaultFirmName;

        // Modal HTML'ini dinamik olarak ekliyoruz
        var modalHtml = `
            <div id="solokargoCustomModal">
			<div class="wc-backbone-modal wc-order-preview">
				<div class="wc-backbone-modal-content" tabindex="0">
					<section class="wc-backbone-modal-main" role="main">
						<header class="wc-backbone-modal-header">
							<mark class="order-status"><span id="defaultFirm">${defaultFirm}</span></mark>
                            <h1>SoloKargo Toplu Kargo Gönderimi</h1>
							<button id="solokargoCloseModal" class="modal-close modal-close-link dashicons dashicons-no-alt">
								<span class="screen-reader-text">Pencereyi kapat</span>
							</button>
						</header>
						
                        <article style="max-height: 801px;">
							<div class="wc-order-preview-addresses">
                                <div class="wc-order-preview-address">
                                    <h2>Gönderim bilgileri</h2>
                                    <p>Seçilen siparişler için toplu gönderim bilgisi oluşturulacaktır. Gönderim için gerekli irsaliye numarası sistem tarafından otomatik olarak oluşturulacaktır. Lütfen gönderim bitine kadar bu pencereyi kapatmayın.</p>
                                </div>
							</div>
                            <div class="wc-order-preview-addresses">
                                <div class="wc-order-preview-address">
                                    <div id="loadingMessage" style="display: none;">
                                        <span id="loadingText">İşlem yapılıyor...</span>
                                        <div class="spinner"></div>
                                    </div>
                                    <strong>Kargolanacak siparişler:</strong>
                                    ${html}
                                </div>
                            </div>
                        </article>

						<footer>
							<div class="inner">
								<a id="solokargoSendButton" class="button button-primary button-large" href="#"> Gönderimi Başlat </a>
							</div>
						</footer>
					</section>
				</div>
			</div>
			<div class="wc-backbone-modal-backdrop modal-close"></div>
		</div>
        `;

        // Modal'ı sayfaya ekliyoruz
        document.body.insertAdjacentHTML('beforeend', modalHtml);

        // Event delegation kullanarak click eventini dinliyoruz
        /*
        document.body.addEventListener('click', function(event) {
            console.info("body tiklama calisti...");
            // Butona tıklanıp tıklanmadığını kontrol ediyoruz
            if (event.target && (event.target.id === 'close-modal' || event.target.id === 'submit-modal')) {
                console.info("close-model yakalandi....");
                closeModal();
            }
        });
        */

        // Gonderim butonuna tıklanınca islemi baslat
        var sendButton = document.getElementById('solokargoSendButton');
        sendButton.addEventListener('click', function () {
            sendButton.disabled = true;
            document.getElementById('loadingMessage').style.display = 'flex';
            sendShipment();
        });

        // Kapatma butonuna tıklanınca modal'ı kapatma
        var closeButton = document.getElementById('solokargoCloseModal');
        closeButton.addEventListener('click', function () {
            closeModal();
        });
    }

    async function sendShipment() {
        console.log("Gönderimi başlat");

        const apiUrl = `${window.location.origin}/wp-json/solokargo/v1/metabox/entry`
        for (const order of orderList) {
            try {
                const params2 = {
                    orderID: order.id,
                    firm: order.defaultFirm,
                    invoiceNo: '20241113'
                };

                if (order.isSend) { // Zaten kargolanmis ise atla
                    continue;
                }

                const params = new FormData();
                params.append('orderID', order.id);
                params.append('firm', order.defaultFirm);
                params.append('invoiceNo', '2334234');

                const options = {
                    header: { 'Content-Type': 'application/json' },
                    method: "POST",
                    body: params,       // JSON.stringify(params),
                };

                const response = await fetch(apiUrl, options);
                if (response.ok) {
                    const responseData = await response.json();
                    console.info(responseData);

                    const ul = document.getElementById('solokargoSendOrderList');
                    const li = ul.querySelector(`li[data-id="${order.id}"]`);

                    if (responseData.status) {
                        li.innerHTML = li.innerHTML + ' -- tamamlandı';
                    } else {
                        li.innerHTML = li.innerHTML + ' -- hata: ' + responseData.message;
                    }

                    order.isSend = true; // kargolanmis olarak ayarla
                    console.log(`Veri ${order.id} başarıyla gönderildi`, responseData);
                } else {
                    console.error(`Veri ${order.id} gönderilemedi. Hata: ${response.status}`);
                }
            } catch (error) {
                console.error(`Veri ${order.id} gönderilirken hata oluştu:`, error);
            }
        }
        document.getElementById('loadingMessage').style.display = 'none';
    }

    // Modal'ı kapama fonksiyonu
    function closeModal() {
        console.info("kapat calisiyor....");

        var modal = document.getElementById('solokargoCustomModal');
        var overlay = document.getElementById('modal-overlay');

        if (modal) {
            modal.remove();
        }
        if (overlay) {
            overlay.remove();
        }
    }

    async function getOrderList(selectedIds) {
        try {
            const options = {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: new URLSearchParams({
                    action: 'getOrderModalData',  // PHP tarafında tanımlı AJAX action
                    order_ids: JSON.stringify(selectedIds),
                })
            }

            const response = await fetch('/wp-admin/admin-ajax.php', options);
            const res = await response.json();

            if (res.success) {
                orderList = res.data;
                console.log(orderList);
                return res.data;
            } else {
                console.log('Sipariş bilgileri alınamadı.');
                return null;  // Sipariş verisi alınamadıysa null döndür
            }

        } catch (error) {
            console.error('Hata:', error);
            return null;  // Hata durumunda null döndür
        }
    }

    async function createBarcodeIFrame(selectedIds) {
        debugger;
        // 1. Yeni bir iframe elementi oluşturun
        var iframe = document.createElement('iframe');

        // 2. iframe özelliklerini ayarlayın (örneğin, kaynak, boyutlar vb.)
        iframe.srcdoc = await getBarcodeData(selectedIds);
        iframe.width = "600";                    // iframe genişliği
        iframe.height = "400";                   // iframe yüksekliği
        iframe.style.border = "none";            // iframe sınırlarını kaldırın

        // 3. iframe'i <body> etiketinin sonuna ekleyin (</body> etiketinin hemen öncesine)
        document.body.appendChild(iframe);

        iframe.onload = function () {
            var iframeDocument = iframe.contentDocument || iframe.contentWindow.document;

            // Yazdırma için özel stil ekle
            var style = iframeDocument.createElement('style');
            style.innerHTML = '@media print {height:0px; width:0px;position:absolute;}}'>
            iframeDocument.head.appendChild(style);

            iframe.contentWindow.print();
        };
    }

    async function  getBarcodeData(selectedIds) {
        try {
            const options = {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: new URLSearchParams({
                    action: 'getBulkBarcodeData',  // PHP tarafında tanımlı AJAX action
                    order_ids: JSON.stringify(selectedIds),
                })
            }

            const response = await fetch('/wp-admin/admin-ajax.php', options);
            const res = await response.json();

            if (res.success) {
                return res.data.data;
            } else {
                console.log('Barkod bilgileri alınamadı.');
                return null;  // Sipariş verisi alınamadıysa null döndür
            }

        } catch (error) {
            console.error('Hata:', error);
            return null;  // Hata durumunda null döndür
        }
    }
});