import { useState } from 'react'
import Spinner from './Spinner'
import { useQueryClient } from '@tanstack/react-query'
import { useGetCargoInfo, useDeleteCargoParams, useGetPrintInfo } from '../api/metaboxApi'

const BoxDetail = (props) => {
    const [message, setMessage] = useState('');
    const [isApiQuery, setIsApiQuery] = useState(false);

    const { data: cargoInfo, isLoading, isRefetching, refetch } = useGetCargoInfo(props.orderID, isApiQuery);
    const { data: printInfo } = useGetPrintInfo(props.orderID);
    const { mutate: delBoxParams } = useDeleteCargoParams();

    const queryClient = useQueryClient();

    function barcodeClick(event) {
        event.preventDefault();

        let print = document.getElementById('iframePrintContent').contentWindow;
        print.focus();
        print.print();
    }

    async function fetchClick(event) {
        event.preventDefault();

        queryClient.invalidateQueries(["cargoInfo"])
        queryClient.refetchQueries("cargoInfo")

        setIsApiQuery(true)

        const result = await refetch();
        console.log(result);
        
        if (result.isSuccess && !result.data.status) {
            setMessage(result.data.message);
        }
    }

    function cancelClick(event) {
        event.preventDefault();

        delBoxParams(props.orderID, {
            onSuccess: (data) => {
                console.log(data);
                if (data.status) {
                    props.setShowDetail(false);
                } else {
                    setMessage(data.message);
                }
            },
            onError: (error) => {
                console.log(error);
            }
        });
    }

    return (
        <div class="boxContainer">
            
            <Spinner isLoading={isLoading || isRefetching} />

            {message && (<div className="boxMessage">{message}</div>)}

            <div className="boxInfo">
                <img src={props.getFirmLogo(cargoInfo?.selectedFirm)} alt='Firma Logo' className='kargoLogo' width={256} height={100} />
                <div className='infoPanel' style={{ padding: '0.75em 0' }}>
                    <span>Durum:</span>
                    <strong>{cargoInfo?.cargoStatus}</strong>
                    <span>Barkod:</span>
                    <strong>{cargoInfo?.barcode}</strong>
                    <span>Takip Kodu:</span>
                    <strong>{cargoInfo?.trackingCode}</strong>
                </div>
                <span class="note">Gönderi bilgileri kargo firmasına iletildi. Lütfen kargonuzu barkod numarası ile şubeye teslim ediniz.</span>
            </div>

            <div className='firmBar'>
                <div>Solokod</div>
                <span>v{cargoInfo?.version}</span>
            </div>

            <hr />

            <div className="boxBar">
                <button className="button button-primary" onClick={barcodeClick}>Barkod</button>
                <button class="button btnSorgula" onClick={fetchClick}>Sorgula</button>
                <button className="button btnIptal" onClick={cancelClick}>İptal</button>
            </div>

            <iframe
                id="iframePrintContent"
                srcDoc={printInfo?.data}
                style={{ height: '0px', width: '0px', position: 'absolute' }}>
            </iframe>
        </div>
    )
}

export default BoxDetail;