import { useState } from 'react';
import { useGetEntryParams, useSetEntryParams } from '../api/metaboxApi';

const BoxEntry = (props) => {
    const [message, setMessage] = useState('');
    const [invoiceNo, setInvoiceNo] = useState('');
    const [selectedFirm, setSelectedFirm] = useState(props.defaultFirm);
    const [isCreateButtonDisabled, setCreateButtonDisabled] = useState(false);

    const { data: boxParams, isLoading } = useGetEntryParams();
    const { mutate: createNewShippment } = useSetEntryParams();

    if (isLoading) return (<div><h2>Loading...</h2></div>);

    function selectFirmClick(event) {
        event.preventDefault();
        setSelectedFirm(event.target.dataset.firm);
    }

    function handlerCreateCargo(event) {
        event.preventDefault();

        if (invoiceNo == '') {
            setMessage("İrsaliye numarası boş geçilemez! Lütfen kontrol edin.");
            return;
        }
        
        setCreateButtonDisabled(true);

        let orderID = props.orderID;

        let params = new FormData();
        params.append('orderID', orderID);
        params.append('firm', selectedFirm);
        params.append('invoiceNo', invoiceNo);

        createNewShippment(params, {
            onSuccess: (data) => {
                console.log(data);
                if (data.status) {
                    props.setShowDetail(true);
                    debugger;
                    const orderStatusCombo = document.getElementById('order_status');
                    orderStatusCombo.selectedIndex = 3; 
                    
                } else {
                    setMessage(data.message);
                }
                setCreateButtonDisabled(false);
            },
            onError: (error) => {
                console.log(error);
                setMessage(error);
            }
        });
    }

    return (
        <div class="boxContainer">
            {message && (<div className="boxMessage">{message}</div>)}

            <div className="boxInfo">
                <img src={props.getFirmLogo(selectedFirm)} alt='Firma Logo' className='kargoLogo' width={256} height={100} />
                <div>
                    <label>İrsaliye Numarası</label>
                    <input type="text" name="invoiceNo" onChange={(e) => setInvoiceNo(e.target.value)} />
                </div>
            </div>
            <div className='firmBar'>
                <div>
                    {boxParams.firms.map((firm) => (
                        <span>
                            <button onClick={selectFirmClick} data-firm={firm.firmCode}>
                                {firm.firmName}
                            </button>
                        </span>
                    ))}
                </div>
                <span>v{boxParams.version}</span>
            </div>
            <hr />
            <div className="boxBar">
                <button className="button button-primary" onClick={handlerCreateCargo} disabled={isCreateButtonDisabled}>Gönderi Oluştur</button>
            </div>
        </div>
    )
}

export default BoxEntry;