import { useGetEntryParams } from '../api/metaboxApi';
import SoloKargoTruck from '../assets/images/solokargo-truck.png';

const Header = () => {
    const { data: boxParams, isLoading } = useGetEntryParams();

    return (
        <div className="soloKargoHeader">
            <h2>
                <img src={SoloKargoTruck} alt="logo" style={{marginRight:"8px", marginLeft: "2px"}}/>
                <span style={{fontWeight:"bold"}}>SoloKargo Gönderi Entegrasyonu</span>
                { !isLoading ? <span style={{marginLeft:"14px", color:"#666", fontSize:"12px"}}>v{boxParams?.version}</span> : null }
            </h2>
            <hr />
        </div>
    )
}

export default Header;