import { useState, useEffect } from 'react';
import { Card, CardHeader, CardBody } from '@wordpress/components'
import { __experimentalHeading as Heading } from "@wordpress/components";
import { useGetOption, useSetLicence } from '../api/optionApi';

const Licence = () => {
    const [message, setMessage] = useState('');
    const { data: licence, isPending, isError, error } = useGetOption('solokargo_licence_info');
    const { mutate: addLicence } = useSetLicence();
   
    function handleSubmit(event) {
        event.preventDefault();

        const data = new FormData(event.target);

        const params = {
            key: 'solokargo_licence_info',
            value: data,
        }
        addLicence(params, {
            onSuccess: (data) => {
                setMessage(data.message);
                // window.location.reload();
            },
            onError: (error) => {
                setMessage(error);
            }
        });
    }

    function getRemainingDays() {
        let currentDate = new Date();
        let endDate = new Date(licence.endDate);
        let timeDifference = endDate - currentDate;
        let remainingDays = Math.ceil(timeDifference / (1000 * 3600 * 24)); 
        
        return `(${remainingDays} gün kaldı)`;
    }

    if (isPending) {
        return <h2>Loading...</h2>
    }

    if (isError) {
        return <h2>{error}</h2>
    }

    return (
        <Card style={{ marginRight: "15px", marginTop: "16px" }}>
            <CardHeader>
                <Heading level={4}>Lisans Bilgileri</Heading>
                <span className='lisansLink'><a href="https://kapi.solokod.com/" target="_blank">Nasıl lisans anahtarı alabilirim?</a></span>
            </CardHeader>
            <CardBody>
                {message != '' && <div className='messageBox'>{message}</div>}

                <form onSubmit={handleSubmit} className="senderForm">
                    <div className="panelLeft">
                        <div class="formFields">
                            <div className="formRow">
                                <label htmlFor="site">Alan Adı</label>
                                <input id="site" name="site" type="text" defaultValue={licence.site} placeholder="Örn: solokod.com" />
                            </div>

                            <div className="formRow">
                                <label htmlFor="licenceKey">Lisans Anahtarı</label>
                                <input id="licenceKey" name="licenceKey" type="text" defaultValue={licence.licenceKey} />
                            </div>

                            <button className="button button-primary" style={{ marginTop: "12px" }} type="submit">Bilgileri Kaydet!</button>
                        </div>
                    </div>
                    <div className="panelRight">
                        <div className="licenceInfoGrid">
                            <label>Lisanslanan Alan Adı</label>
                            <span>{ licence.site || '---' }</span>

                            <label>Paket Türü</label>
                            <span>{ licence.subscribeType || '---' }</span>

                            <label>Abonelik</label>
                            <span>{ licence.subscribeFirm || '---' }</span>

                            <label>Başlangıç Tarihi</label>
                            <span>{ licence.beginDate || '---' }</span>

                            <label>Bitiş Tarihi</label>
                            <span>
                                <span style={{ paddingRight: "12px", color: "#a7aaad" }}>{ getRemainingDays() }</span>
                                { licence.endDate || '---' }
                            </span>
                        </div>
                    </div>
                </form>
            </CardBody>
        </Card>
    )
}

export default Licence;