import { useState, useEffect } from 'react';
import { Card, CardHeader, CardBody } from '@wordpress/components'
import { __experimentalHeading as Heading } from "@wordpress/components";
import { useGetOption, useSetOption } from '../api/optionApi';
import { formDataToNestedObject } from '../utils';

const MngForm = () => {
    const [message, setMessage] = useState('');
    const { data, isPending, isError, error } = useGetOption('solokargo_mng_info');
    const { mutate: addOption } = useSetOption();

    function handleSubmit(event) {
        event.preventDefault();

        const rawData = new FormData(event.target);
        const formattedData = formDataToNestedObject(rawData);
        
        const formData = new FormData();
        formData.append("data", JSON.stringify(formattedData)); 

        const params = {
            key: 'solokargo_mng_info',
            value: formData,
        }
        addOption(params, {
            onSuccess: (data) => {
                setMessage(data.message);
            },
            onError: (error) => {
                setMessage(error);
            }
        });
    }

    if (isPending) {
        return <h2>Loading...22</h2>
    }

    if (isError) {
        return <h2>{error}</h2>
    }

    return (
        <Card style={{ marginRight: "15px" }}>
            <CardHeader>
                <Heading level={4}>MNG Kargo Bilgileri</Heading>
            </CardHeader>
            <CardBody>
                {message != '' && <div className='messageBox'>{message}</div>}

                <form onSubmit={handleSubmit} className="mngForm">
                    <div class="form-columns">
                        <div class="form-column">
                            <div class="form-group">
                                <label htmlFor="paymentMethod">Ödeme Şekli</label>
                                <select id="paymentMethod" name="paymentMethod" defaultValue={data.paymentMethod}>
                                    <option value="P">Nakit</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="cargoContent">Kargo İçeriği:</label>
                                <input type="text" id="cargoContent" name="cargoContent" defaultValue={data.cargoContent} />
                            </div>
                        </div>
                        <div class="form-column">
                            <div class="form-group">
                                <label for="credentials.username">Kullanıcı Adı</label>
                                <input type="text" id="credentials.username" name="credentials.username" defaultValue={data?.credentials?.username} />
                            </div>
                            <div class="form-group">
                                <label for="credentials.password">Parola</label>
                                <input type="text" id="credentials.password" name="credentials.password" defaultValue={data?.credentials?.password} />
                            </div>
                            <div class="form-group">
                                <label htmlFor="workMode">Çalışma Ortamı</label>
                                <select id="workMode" name="workMode" defaultValue={data.workMode}>
                                    <option value="test">Test Ortamı</option>
                                    <option value="prod">Gerçek Ortam</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group submit-group">
                        <button className="button button-primary" style={{ marginTop: "12px" }} type="submit">Bilgileri Kaydet!</button>
                    </div>
                </form>
            </CardBody>
        </Card>
    )
}

export default MngForm;