import { useState, useEffect } from 'react';
import { Card, CardHeader, CardBody } from '@wordpress/components'
import { __experimentalHeading as Heading } from "@wordpress/components";
import { useGetOption, useSetOption } from '../api/optionApi';

const SenderForm = () => {
    const [message, setMessage] = useState('');
    const [showSenderPhone, setShowSenderPhone] = useState(false);

    const { data, isPending, isError, error } = useGetOption('solokargo_sender_info');
    const { mutate: addOption } = useSetOption();

    useEffect(() => {
        console.log(data);
        if (data && data.showSenderPhone !== undefined) {
            setShowSenderPhone(data.showSenderPhone == 'on' ? true : false);
        }
    }, [data]);

    if (isPending) {
        return <h2>Loading...</h2>
    }

    if (isError) {
        return <h2>{error}</h2>
    }

    const handleCheckboxChange = (event) => {
        setShowSenderPhone(event.target.checked);
    };

    function handleSubmit(event) {
        event.preventDefault();

        const data = new FormData(event.target);
        data.append('showSenderPhone', showSenderPhone ? 'on' : 'off');
        
        const formattedData = formDataToNestedObject(data);

        const formData = new FormData();
        formData.append("data", JSON.stringify(formattedData)); 

        const params = {
            key: 'solokargo_sender_info',
            value: formData,
        }
        addOption(params, {
            onSuccess: (data) => {
                setMessage(data.message);
            },
            onError: (error) => {
                setMessage(error);
            }
        });
    }

    function formDataToNestedObject(formData) {
        const result = {};

        for (let [key, value] of formData.entries()) {
            const keys = key.split(".");
            let current = result;

            // İç içe yerleştirme döngüsü
            keys.forEach((k, index) => {
                if (index === keys.length - 1) {
                    // Son anahtar için değeri ata
                    current[k] = value;
                } else {
                    // Mevcut anahtar için nesneyi oluştur veya devam et
                    if (!current[k]) current[k] = {};
                    current = current[k];
                }
            });
        }

        return result;
    }

    return (
        <Card style={{ marginRight: "15px" }}>
            <CardHeader>
                <Heading level={4}>Gönderici Bilgileri</Heading>
            </CardHeader>
            <CardBody>
                {message != '' && <div className='messageBox'>{message}</div>}

                <form onSubmit={handleSubmit} className="senderForm">
                    <div className="panelLeft">
                        <div class="formFields">
                            <div className="formRow">
                                <label htmlFor="title">Firma Ünvanı</label>
                                <input id="title" name="title" type="text" defaultValue={data.title} />
                            </div>

                            <div className="formRow">
                                <label htmlFor="phone">Telefon</label>
                                <input id="phone" name="phone" type="text" defaultValue={data.phone} />
                            </div>

                            <div className="formRow">
                                <label htmlFor="email">E-posta</label>
                                <input id="email" name="email" type="email" defaultValue={data.email} />
                            </div>

                            <div className="formRow">
                                <label htmlFor="address">Adres</label>
                                <textarea id="address" name="address" defaultValue={data.address}></textarea>
                            </div>

                            <button className="button button-primary" style={{ marginTop: "12px" }} type="submit">Bilgileri Kaydet!</button>
                        </div>
                    </div>
                    <div className="panelRight">
                        <div className="formFields">
                            <div className="formRow">
                                <label htmlFor="barcodeTemplate">Barkod Şablonu</label>
                                <select id="barcodeTemplate" name="barcodeTemplate" defaultValue={data.barcodeTemplate}>
                                    <option value="template1">Şablon 1</option>
                                    <option value="template2">Şablon 2 (Ürünlü)</option>
                                    <option value="template3">Şablon 3 (A5)</option>
                                </select>
                            </div>

                            <div className="formRow" style={{ marginTop: "30px" }}>
                                <label htmlFor="showSenderPhone">
                                    <input id="showSenderPhone" name="showSenderPhone" type="checkbox" checked={showSenderPhone} onChange={handleCheckboxChange} />
                                    Gönderici telefonunu göster/gizle
                                </label>
                            </div>
                        </div>
                    </div>
                </form>
            </CardBody>
        </Card>
    )
}

export default SenderForm;