import React from 'react';

function Spinner({ isLoading }) {
    return (
        <>
            {isLoading && (
                <div style={styles.loadContainer}>
                    <div style={styles.loadSpinner}></div>
                </div>
            )}
        </>
    );
}

const styles = {
    loadContainer: {
        position: 'absolute',  // Spinner'ı ortalamak için
        top: 0,
        left: 0,
        width: '100%',
        height: '100%',
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center',
        backgroundColor: 'rgba(255, 255, 255, 0.7)',  // Yarı saydam arka plan
        zIndex: 10,
    },
    loadSpinner: {
        width: '40px',
        height: '40px',
        border: '4px solid #ccc',
        borderTop: '4px solid #333',
        borderRadius: '50%',
        animation: 'spin 1s linear infinite',
    },
};

// CSS animasyonu
const spinnerStyles = `
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }`;

document.head.insertAdjacentHTML("beforeend", `<style>${spinnerStyles}</style>`);

export default Spinner;
