import { useState } from 'react';
import { Card, CardHeader, CardBody } from '@wordpress/components'
import { __experimentalHeading as Heading } from "@wordpress/components";
import { useGetOption, useSetOption } from '../api/optionApi';

const TestForm = () => {
    const [message, setMessage] = useState('');
    const { data, isPending, isError, error } = useGetOption('solokargo_test_info');
    const { mutate: addOption } = useSetOption();

    if (isPending) {
        return <h2>Loading...</h2>
    }

    if (isError) {
        return <h2>{error}</h2>
    }

    function handleSubmit(event) {
        event.preventDefault();

        const rawData = new FormData(event.target);
        const formattedData = formDataToNestedObject(rawData);
        
        const formData = new FormData();
        formData.append("data", JSON.stringify(formattedData));

        const params = {
            key: 'solokargo_test_info',
            value: formData,
        }
        addOption(params, {
            onSuccess: (data) => {
                setMessage(data.message);
            },
            onError: (error) => {
                setMessage(error);
            }
        });
    }

    function formDataToNestedObject(formData) {
        const result = {};

        for (let [key, value] of formData.entries()) {
            const keys = key.split(".");
            let current = result;

            // İç içe yerleştirme döngüsü
            keys.forEach((k, index) => {
                if (index === keys.length - 1) {
                    // Son anahtar için değeri ata
                    current[k] = value;
                } else {
                    // Mevcut anahtar için nesneyi oluştur veya devam et
                    if (!current[k]) current[k] = {};
                    current = current[k];
                }
            });
        }

        return result;
    }

    return (
        <Card style={{ marginRight: "15px" }}>
            <CardHeader>
                <Heading level={4}>Test Kargo Bilgileri</Heading>
            </CardHeader>
            <CardBody>
                {message != '' && <div className='messageBox'>{message}</div>}

                <form onSubmit={handleSubmit} className="testForm">
                    <div class="form-columns">
                        <div class="form-column">
                            <div class="form-group">
                                <label htmlFor="barcodeTemplate">Kargo Türü</label>
                                <select id="cargoType" name="cargoType" defaultValue={data.cargoType}>
                                    <option value="dosya">Dosya</option>
                                    <option value="poset">Poşet</option>
                                    <option value="koli">Koli</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label htmlFor="tasimaTuru">Taşıma Türü</label>
                                <select id="cargoType" name="cargoType" defaultValue={data.cargoType}>
                                    <option value="kara">Kara Yolu</option>
                                    <option value="hava">Hava Yolu</option>
                                    <option value="deniz">Deniz Yolu</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="email">Kargo İçeriği:</label>
                                <input type="text" id="email" name="email" />
                            </div>
                            <div class="form-group">
                                <label for="seri">irsaliye Seri No:</label>
                                <input type="text" id="seri" name="seri" />
                            </div>
                        </div>
                        <div class="form-column">
                            <div class="form-group">
                                <label for="credentials.username">Kullanıcı Adı:</label>
                                <input type="text" id="credentials.username" name="credentials.username" defaultValue={data?.credentials?.username}/>
                            </div>
                            <div class="form-group">
                                <label for="credentials.password">Parola:</label>
                                <input type="text" id="credentials.password" name="credentials.password" defaultValue={data?.credentials?.password} />
                            </div>
                            <div class="form-group">
                                <label for="credentials.webPass">Web Parola:</label>
                                <input type="text" id="credentials.webPass" name="credentials.webPass" defaultValue={data?.credentials?.webPass} />
                            </div>
                            <div class="form-group">
                                <label htmlFor="workMode">Çalışma Ortamı</label>
                                <select id="workMode" name="workMode" defaultValue={data.workMode}>
                                    <option value="test">Test Ortamı</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group submit-group">
                        <button className="button button-primary" style={{ marginTop: "12px" }} type="submit">Bilgileri Kaydet!</button>
                    </div>
                </form>
            </CardBody>
        </Card>
    )
}

export default TestForm;