import { useState, useEffect } from 'react';
import { Card, CardHeader, CardBody } from '@wordpress/components'
import { __experimentalHeading as Heading } from "@wordpress/components";
import { useGetOption, useSetOption } from '../api/optionApi';

const YurticiForm = () => {
    const [message, setMessage] = useState('');
    const { data, isPending, isError, error } = useGetOption('solokargo_yurtici_info');
    const { mutate: addOption } = useSetOption();

    function handleSubmit(event) {
        //stopPropagation
        event.preventDefault();
        const data = new FormData(event.target);

        const params = {
            key: 'solokargo_yurtici_info',
            value: data,
        }
        addOption(params, {
            onSuccess: (data) => {
                setMessage(data.message);
            },
            onError: (error) => {
                setMessage(error);
            }
        });
    }

    if (isPending) {
        return <h2>Loading...</h2>
    }

    if (isError) {
        return <h2>{error}</h2>
    }

    return (
        <Card style={{ marginRight: "15px" }}>
            <CardHeader>
                <Heading level={4}>Yurtiçi Kargo Bilgileri</Heading>
            </CardHeader>
            <CardBody>
                {message != '' && <div className='messageBox'>{message}</div>}

                <form onSubmit={handleSubmit} className="yurticiForm">
                    <div className="panelLeft">
                        <div class="formFields">
                            <div className="formRow">
                                <label htmlFor="barcodeTemplate">Kargo Türü</label>
                                <select id="cargoType" name="cargoType" defaultValue={data.cargoType}>
                                    <option value="dosya">Dosya</option>
                                    <option value="poset">Poşet</option>
                                    <option value="koli">Koli</option>
                                </select>
                            </div>

                            <div className="formRow">
                                <label htmlFor="phone">Telefon</label>
                                <input id="phone" name="phone" type="text" defaultValue={data.phone} />
                            </div>

                            <div className="formRow">
                                <label htmlFor="email">E-posta</label>
                                <input id="email" name="email" type="email" defaultValue={data.email} />
                            </div>

                            <div className="formRow">
                                <label htmlFor="address">Adres</label>
                                <textarea id="address" name="address" defaultValue={data.address}></textarea>
                            </div>

                            <button className="button button-primary" style={{ marginTop: "12px" }} type="submit">Bilgileri Kaydet!</button>
                        </div>
                    </div>
                    <div className="panelRight">
                        <div className="formFields">
                            <div className="formRow">
                                <label htmlFor="title">Gönderici Ödemeli - Kullanıcı Adı</label>
                                <input id="title" name="sendUserName" type="text" defaultValue={data.sendUserName} />
                            </div>
                            <div className="formRow">
                                <label htmlFor="title">Gönderici Ödemeli - Şifre</label>
                                <input id="title" name="sendPassword" type="text" defaultValue={data.sendPassword} />
                            </div>
                            <hr />
                            <div className="formRow">
                                <label htmlFor="title">Alıcı Ödemeli - Kullanıcı Adı</label>
                                <input id="title" name="receiveUserName" type="text" defaultValue={data.receiveUserName} />
                            </div>
                            <div className="formRow">
                                <label htmlFor="title">Alıcı Ödemeli - Şifre</label>
                                <input id="title" name="receivePassword" type="text" defaultValue={data.receivePassword} />
                            </div>
                            <hr />
                            <div className="formRow">
                                <label htmlFor="title">Gönderici Ödemeli Tahsilatlı - Kullanıcı Adı</label>
                                <input id="title" name="sendDeliverUserName" type="text" defaultValue={data.sendDeliverUserName} />
                            </div>
                            <div className="formRow">
                                <label htmlFor="title">Gönderici Ödemeli Tahsilatlı - Şifre</label>
                                <input id="title" name="sendDeliverPassword" type="text" defaultValue={data.sendDeliverPassword} />
                            </div>
                            <hr />
                            <div className="formRow">
                                <label htmlFor="title">Alıcı Ödemeli Tahsilatlı - Kullanıcı Adı</label>
                                <input id="title" name="receiveDeliverUserName" type="text" defaultValue={data.receiveDeliverUserName} />
                            </div>
                            <div className="formRow">
                                <label htmlFor="title">Alıcı Ödemeli Tahsilatlı - Şifre</label>
                                <input id="title" name="receiveDeliverPassword" type="text" defaultValue={data.receiveDeliverPassword} />
                            </div>

                        </div>
                    </div>
                </form>
            </CardBody>
        </Card>
    )
}

export default YurticiForm;