import Header from './components/Header';
import SenderForm from './components/SenderForm';
import LicenceForm from './components/LicenceForm';

import './assets/styles/dashboard.scss';

import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
const queryClient = new QueryClient();

const Dashboard = () => {
    return (
        <>
            <Header />
            <SenderForm />            
            <LicenceForm />
        </>
    )
}

if (document.getElementById('solokargoDashboard')) {
    ReactDOM.createRoot(document.getElementById('solokargoDashboard')).render(
        <React.StrictMode>
            <QueryClientProvider client={queryClient}>
                <Dashboard />
            </QueryClientProvider>
        </React.StrictMode>
    )
}