const { getSetting } = window.wc.wcSettings;

const settings = getSetting('kapida_odeme_kart_data');
let label = window.wp.htmlEntities.decodeEntities(settings.title);

// React Label Component
const Label = (props) => {
    const { PaymentMethodLabel } = props.components
    return <PaymentMethodLabel text={label} />
}

// React Content Component
const Content = () => {
    return settings.description;
}

const options = {
	name: "kapida_odeme_kart",
    label: <Label />,
    content: <Content />,
    edit: <Content />,
    ariaLabel: label,
    supports: {
        features: settings.supports,
    },
    canMakePayment: () => true,
};

window.wc.wcBlocksRegistry.registerPaymentMethod(options);