import { useState } from 'react';
import BoxEntry from './components/BoxEntry';
import BoxDetail from './components/BoxDetail';

import YurticiLogo from './assets/images/yurtici-logo.svg';
import SuratLogo from './assets/images/surat-logo.svg';
import ArasLogo from './assets/images/aras-logo.svg';
import MngLogo from './assets/images/mng-logo.svg';
import TestLogo from './assets/images/test-logo.svg';

import './assets/styles/metabox.scss';

import { QueryClient, QueryClientProvider } from "@tanstack/react-query";

const queryClient = new QueryClient();

const Metabox = (props) => {
    const [showDetail, setShowDetail] = useState(props.selectedFirm.length > 0 ? true : false);
  
    function getFirmLogo(firm) {
        switch (firm) {
            case 'yurtici':
                return YurticiLogo;
            case 'surat':
                return SuratLogo;
            case 'aras':
                return ArasLogo;
            case 'mng':
                return MngLogo;
            case 'test':
                return TestLogo;
            default:
                return TestLogo;
        }
    }

    return (
        showDetail
            ? <BoxDetail orderID={props.orderID} getFirmLogo={getFirmLogo} setShowDetail={setShowDetail} />
            : <BoxEntry orderID={props.orderID} getFirmLogo={getFirmLogo} setShowDetail={setShowDetail} defaultFirm={props.defaultFirm} />
    )
}

if (document.getElementById('solokargobox')) {
    let metaBox = document.getElementById('solokargobox');
    let orderID = metaBox.dataset.orderid;
    let selectedFirm = metaBox.dataset.selectedfirm;
    let defaultFirm = metaBox.dataset.defaultfirm;

    ReactDOM.createRoot(metaBox).render(
        <React.StrictMode>
            <QueryClientProvider client={queryClient}>
                <Metabox orderID={orderID} defaultFirm={defaultFirm} selectedFirm={selectedFirm} />
            </QueryClientProvider>
        </React.StrictMode>
    )
}